///////////////////////////////
//	Blowfish DLL Version 1.37
//	By Kwok Ho Yin	1998,1999
///////////////////////////////

#include <windows.h>
#include <windowsx.h>

#ifndef	BFDLLEXP
#define BFDLLEXP	__declspec(dllimport)
#endif

//---------------------------------------------------------------------------

#define	ERROR_FREE									0
#define KEY_TOO_LONG								1
#define NOT_ENOUGH_MEMORY							2
#define BAD_SOURCE									3
#define BAD_SIZE									4
#define NOT_LOCK_SOURCE								5
#define DO_NOT_SUPPORT_FOR_UNREGISTERED_VERSION		6
#define NOT_SUPPORT_PREVIOUS_VERSION				7
#define BAD_CRC										8
#define Cannot_Setup_Compressor						9
#define COMPRESS_ERROR								10
#define Cannot_Setup_Decompressor					11
#define DECOMPRESS_ERROR							12
#define DO_NOT_SUPPORT_DECOMPRESSION				13
#define	BAD_BLOCK_RECORD							14
#define BAD_PROCESS_BLOCK							15
#define NOT_ENOUGH_DATA								16
#define	CANNOT_OPEN_FILE							17
#define CANNOT_CREATE_FILE							18

#define	BF_SB_BEGIN									0
#define BF_SB_MID									1
#define BF_SB_END									2

#define ENCRYPT_COMPLETED							0
#define	DECRYPT_COMPLETED							1

//---------------------------------------------------------------------------

///////////////////
//	DLL functions

#ifdef __cplusplus
extern "C" {
#endif

BFDLLEXP void WINAPI BF_SetBlowfishKey(const char *key);

BFDLLEXP BYTE* WINAPI BF_Auto_Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
BFDLLEXP BYTE* WINAPI BF_Auto_Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
BFDLLEXP BYTE* WINAPI BF_Auto_Decipher_Text(BYTE *SourcePtr, UINT InSize, UINT *OutSize);

BFDLLEXP BOOL WINAPI BF_InitializeKey(void);
BFDLLEXP BYTE* WINAPI BF_Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
BFDLLEXP BYTE* WINAPI BF_Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
BFDLLEXP BYTE* WINAPI BF_Decipher_Text(BYTE *SourcePtr, UINT InSize, UINT *OutSize);

BFDLLEXP void WINAPI BF_Free_ResultBuffer(BYTE *Ptr);

BFDLLEXP BYTE* WINAPI BF_CreateProcessBlock(void);
BFDLLEXP void WINAPI BF_FreeProcessBlock(BYTE *ProcessBlockPtr);

BFDLLEXP BYTE* WINAPI BF_Encipher_SmallBlock(BYTE *SourcePtr, UINT InSize, UINT *OutSize, BYTE *FirstSmallBlockPtr, BYTE *ProcessRecordPtr, char flag);
BFDLLEXP BYTE* WINAPI BF_Decipher_SmallBlock(BYTE *SourcePtr, UINT InSize, UINT *OutSize, BYTE *ProcessRecordPtr, char flag);

BFDLLEXP BOOL WINAPI BF_Encipher_File(const char *inputfilename, const char *outputfilename, DWORD *OutSize);
BFDLLEXP BOOL WINAPI BF_Decipher_File(const char *inputfilename, const char *outputfilename, DWORD *OutSize);

typedef BOOL (CALLBACK* CALLBACKFUNCPTR)(char status, DWORD TotalData);
BFDLLEXP void WINAPI BF_SetCallbackFunc(CALLBACKFUNCPTR Funcptr);

BFDLLEXP void WINAPI BF_GetErrorString(char *String);
BFDLLEXP UINT WINAPI BF_GetErrorCode(void);

BFDLLEXP void WINAPI BF_SetCrcChecker(BOOL flag);
BFDLLEXP void WINAPI BF_SetCompression(BOOL flag);
BFDLLEXP void WINAPI BF_SetErrorLogFile(BOOL flag);

BFDLLEXP void WINAPI BF_GetVersion(UINT *Major, UINT *Minor, UINT *Extra, UINT *Special);

//////////////////////
//	For dynamic link 

typedef void (CALLBACK *BFGETVERSIONPROC)(UINT *, UINT *, UINT *, UINT *);
typedef void (CALLBACK *BFSETBLOWFISHKEYPROC)(const char *);

typedef BYTE* (CALLBACK *BFAUTOENCIPHERPROC)(BYTE *, UINT, UINT *);
typedef BYTE* (CALLBACK *BFAUTODECIPHERPROC)(BYTE *, UINT, UINT *);
typedef BYTE* (CALLBACK *BFAUTODECIPHERTEXTPROC)(BYTE *, UINT, UINT *);

typedef BOOL (CALLBACK *BFINITIALIZEKEYPROC)(void);
typedef BYTE* (CALLBACK *BFENCIPHERPROC)(BYTE *, UINT, UINT *);
typedef BYTE* (CALLBACK *BFDECIPHERPROC)(BYTE *, UINT, UINT *);
typedef BYTE* (CALLBACK *BFDECIPHERTEXTPROC)(BYTE *, UINT, UINT *);

typedef void (CALLBACK *BFFREERESULTBUFFERPROC)(BYTE *);

typedef BYTE* (CALLBACK *BFCREATEPROCESSBLOCKPROC)(void);
typedef void (CALLBACK *BFFREEPROCESSBLOCKPROC)(BYTE *);

typedef BYTE* (CALLBACK *BFENCIPHERSMALLBLOCKPROC)(BYTE *, UINT, UINT *, BYTE *, BYTE *, char);
typedef BYTE* (CALLBACK *BFDECIPHERSMALLBLOCKPROC)(BYTE *, UINT, UINT *, BYTE *, char);

typedef BOOL (CALLBACK *BFENCIPHERFILEPROC)(const char *, const char *, DWORD *);
typedef BOOL (CALLBACK *BFDECIPHERFILEPROC)(const char *, const char *, DWORD *);

typedef void (CALLBACK *BFSETCALLBACKFUNCPROC)(CALLBACKFUNCPTR);

typedef void (CALLBACK *BFGETERRORSTRINGPROC)(char *);
typedef UINT (CALLBACK *BFGETERRORCODEPROC)(void);

typedef void (CALLBACK *BFSETCRCCHECKERPROC)(BOOL);
typedef void (CALLBACK *BFSETCOMPRESSIONPROC)(BOOL);
typedef void (CALLBACK *BFSETERRORLOGFILEPROC)(BOOL);

#ifdef __cplusplus
}
#endif
